@echo off
title nRF5340 Programming Script
echo Starting PCA374 Programming
echo.
@REM Look for PCA374.hex
set "filename="
for /R %%i in (auracast_*) do (
    set "filename=%%~nxi"
    goto :break
)
if not defined filename (
    echo No file found that starts with "auracast_", make sure the correct .hex file is in the same directory. Program will exit after keystroke.
    pause
    exit /b
)
:break
echo %filename% found
echo.

@REM Make sure there is a device connected
nrfjprog --deviceversion > pca374_progoutput.txt 2>&1

@REM Check for low voltage error 
findstr /i "Low voltage" pca374_progoutput.txt > nul
IF %ERRORLEVEL% NEQ 0 (
    echo Connected Devices:
    type pca374_progoutput.txt
) ELSE (
    powershell -Command "Write-Host 'ERROR: Low voltage detected in target device. Ensure device is connected and properly powered.' -ForegroundColor Red"
    echo. 
    powershell -Command "Write-Host 'FAILURE' -ForegroundColor Red"
    echo.
    pause
    exit /b 1
)

echo.
echo Erasing memory and resetting...
nrfjprog --eraseall > pca374_progoutput.txt 2>&1

@REM Check for readback protections. If so, recover the device before attempting to program
findstr "protection" pca374_progoutput.txt > nul
IF %ERRORLEVEL% EQU 0 (
    powershell -Command "Write-Host 'Device protections detected when attempting erase. Performing device auto-recovery, please wait...' -ForegroundColor Blue"
    nrfjprog --family NRF53 --recover
)

@REM Check that debugger is connected by searching for "No debugger" error
findstr "No debugger" pca374_progoutput.txt > nul
IF %ERRORLEVEL% NEQ 0 (

    echo Device version fetched successfully.

) ELSE (
        type pca374_progoutput.txt
        powershell -Command "Write-Host 'ERROR: No debugger found. Ensure that Segger Flasher device is connected.' -ForegroundColor Red"
        echo. 
        powershell -Command "Write-Host 'FAILURE' -ForegroundColor Red"
        echo.
        pause
        exit /b 1
)

nrfjprog --reset
echo.

echo Programming the network core...
nrfjprog --program %filename% 0f -f NRF53 --sectorerase --coprocessor CP_NETWORK --verify 2> pca374_progoutput.txt
IF %ERRORLEVEL% NEQ 0 (
    powershell -Command "Write-Host 'Device protections detected when programming network core. Performing device auto-recovery, please wait...' -ForegroundColor Blue"
    nrfjprog --family NRF53 --recover --log --coprocessor CP_NETWORK 2> pca374_progoutput.txt
    nrfjprog --eraseall
    nrfjprog --reset
    nrfjprog --program %filename% 0f -f NRF53 --sectorerase --coprocessor CP_NETWORK --verify 2> pca374_progoutput.txt
) ELSE (
    echo Network core programmed successfully.
)

echo Programming the application core...
nrfjprog --program %filename% 0f -f NRF53 --coprocessor CP_APPLICATION --verify 2> pca374_progoutput.txt
IF %ERRORLEVEL% NEQ 0 (
    powershell -Command "Write-Host 'Device protections detected when programming application core. Performing device auto-recovery, please wait...' -ForegroundColor Blue"
    nrfjprog --family NRF53 --recover --log --coprocessor CP_APPLICATION
    nrfjprog --program %filename% 0f -f NRF53 --coprocessor CP_APPLICATION --verify 2> pca374_progoutput.txt
) ELSE (
    echo Application core programmed successfully.
    echo.
)
echo Resetting device.
echo.
nrfjprog --family NRF53 --reset
echo.

@REM Report success to the terminal
powershell -Command "Write-Host 'SUCCESS!' -ForegroundColor Green"
echo.
pause